% ----------------------------------------------------------------------- %
%                     MATLAB GUI MAKER SYSTEM CODE                        %
% ----------------------------------------------------------------------- %

function varargout = VideoPlaybackGUI(varargin)
% VIDEOPLAYBACKGUI MATLAB code for VideoPlaybackGUI.fig
%      VIDEOPLAYBACKGUI, by itself, creates a new VIDEOPLAYBACKGUI or raises the existing
%      singleton*.
%
%      H = VIDEOPLAYBACKGUI returns the handle to a new VIDEOPLAYBACKGUI or the handle to
%      the existing singleton*.
%
%      VIDEOPLAYBACKGUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in VIDEOPLAYBACKGUI.M with the given input arguments.
%
%      VIDEOPLAYBACKGUI('Property','Value',...) creates a new VIDEOPLAYBACKGUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before VideoPlaybackGUI_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to VideoPlaybackGUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help VideoPlaybackGUI

% Last Modified by GUIDE v2.5 02-Nov-2016 00:18:39

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @VideoPlaybackGUI_OpeningFcn, ...
                   'gui_OutputFcn',  @VideoPlaybackGUI_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before VideoPlaybackGUI is made visible.
function VideoPlaybackGUI_OpeningFcn(hObject, eventdata, handles, varargin)
% Choose default command line output for VideoPlaybackGUI
handles.output = hObject;
% Update handles structure
guidata(hObject, handles);
axis(handles.axes1,'off');
axis(handles.axes2,'off');

% UIWAIT makes VideoPlaybackGUI wait for user response (see UIRESUME)
% uiwait(handles.figure1);

% --- Outputs from this function are returned to the command line.
function varargout = VideoPlaybackGUI_OutputFcn(hObject, eventdata, handles) 
% Get default command line output from handles structure
varargout{1} = handles.output;


% ----------------------------------------------------------------------- %
%                           Video Frame Viewer                            %
% ----------------------------------------------------------------------- %

% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[filename, pathname] = uigetfile({'*.mp4'}, 'File Selector');
video_coronal = strcat(pathname, filename);
set(handles.edit1, 'string', video_coronal);
% VideoReader(video_coronal)

% --- Executes on button press in pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[filename, pathname] = uigetfile({'*.mp4'}, 'File Selector');
video_sagittal = strcat(pathname, filename);
set(handles.edit2, 'string', video_sagittal);
% VideoReader(video_sagittal)


% --- Executes on button press in PlayButton.
function PlayButton_Callback(hObject, eventdata, handles)
% hObject    handle to PlayButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% 
% video_coronal = get( handles.edit1, 'String');
% videoFReader_coronal  = vision.VideoFileReader( video_coronal);
% video_sagittal = get( handles.edit2, 'String');
% videoFReader_sagittal = vision.VideoFileReader( video_sagittal);
% while ~isDone( videoFReader_coronal) && ~isDone( videoFReader_sagittal)
%     frame_coronal = step( videoFReader_coronal);
%     frame_sagittal = step( videoFReader_sagittal);
%     showFrameOnAxiskjp(handles.axes1,frame_coronal);
%     showFrameOnAxiskjp(handles.axes2,frame_sagittal);
%     drawnow
% end


% version 2
video_coronal = get( handles.edit1, 'String');
videoFReader_coronal  = vision.VideoFileReader( video_coronal);
video_sagittal = get( handles.edit2, 'String');
videoFReader_sagittal = vision.VideoFileReader( video_sagittal);
frame_coronal = step( videoFReader_coronal);
frame_sagittal = step( videoFReader_sagittal);
frameSize = size(frame_coronal);
xdata = [1 frameSize(2)];
ydata = [1 frameSize(1)];
cla('reset')
hIm_coronal = image(xdata,ydata,frame_coronal, ...
           'BusyAction', 'cancel', ...
           'Parent', handles.axes1, ...
           'Interruptible', 'off');
hIm_sagittal = image(xdata,ydata,frame_sagittal, ...
           'BusyAction', 'cancel', ...
           'Parent', handles.axes2, ...
           'Interruptible', 'off');
while ~isDone( videoFReader_coronal) && ~isDone( videoFReader_sagittal)
    frame_coronal = step( videoFReader_coronal);
    frame_sagittal = step( videoFReader_sagittal);
    set( hIm_coronal, 'cdata', frame_coronal);
    set( hIm_sagittal, 'cdata', frame_sagittal);
%     drawnow limitrate;
    drawnow;
    axis(handles.axes1,'off');
    axis(handles.axes2,'off');
end


% --- Executes on button press in pushbutton9.
function pushbutton9_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(strcmp(get(handles.pushbutton9,'String'),'Pause'))
    set(handles.pushbutton9,'String','Resume');
    uiwait();
else
    set(handles.pushbutton9,'String','Pause');
    uiresume();
end

% --- Executes on button press in pushbutton10.
function pushbutton10_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
delete(handles.figure1);


% ----------------------------------------------------------------------- %
%                       File Explorer File Path                           %
% ----------------------------------------------------------------------- %

function edit1_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function edit1_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit2_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function edit2_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ----------------------------------------------------------------------- %
%                     Patient Information Textbox                         %
% ----------------------------------------------------------------------- %

function edit3_Callback(hObject, eventdata, handles)
notes = get(handles.edit3, 'string');
assignin('base', 'Notes', notes);

% --- Executes during object creation, after setting all properties.
function edit3_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function edit4_Callback(hObject, eventdata, handles)
name = get(handles.edit4, 'string');
assignin('base', 'Name', name);

% --- Executes during object creation, after setting all properties.
function edit4_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function edit5_Callback(hObject, eventdata, handles)
id = get(handles.edit5, 'string');
assignin('base', 'ID', id);

% --- Executes during object creation, after setting all properties.
function edit5_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ----------------------------------------------------------------------- %
%                      Patient Information Export                         %
% ----------------------------------------------------------------------- %

% --- Executes on button press in pushbutton7.
function pushbutton7_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

textbox_data1= get(handles.edit4,'String');
textbox_data2= get(handles.edit5,'String');
textbox_data3= get(handles.edit3,'String');
fid = fopen('Patient_Information.txt', 'wt');
fprintf(fid, 'Name: %s\nID: %s\nNotes: %s\n', textbox_data1, textbox_data2, textbox_data3);
fclose(fid);


% --- Executes when figure1 is resized.
function figure1_SizeChangedFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
